<?php

namespace App\Http\Controllers\AcademicAll;

use App\Models\Academic\AcademicFeeHead;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\SiteInfo;
use Response;
use Session;

class AcademicFeeHeadController extends Controller
{
    private $academicFeeHead;

    public function __construct(AcademicFeeHead $academicFeeHead)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->academicFeeHead = $academicFeeHead;

    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Fee Head List';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.academic-fee-head.view', compact('viewType'));
    }

    public function getFeeHeadList()
    {
        $feeHeads = new AcademicFeeHead();
        $feeHeadList = $feeHeads->get();

        return $feeHeadList;;

    }



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|unique:academic_fee_heads',

        ]);

        $feeHeads=AcademicFeeHead::create([
            'name' => $request->name,
            'head_key' => $request->head_key,
            'status' => $request->status
        ]);
        return ['message' => 'Successfully Saved!'];

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
//        $this->validate($request,[
//            'name'=>'required|unique:academic_fee_heads'
//
//        ]);

        $feeHeadsUpdate = $this->academicFeeHead->findOrFail($id);

        $feeHeadsUpdate->update([
            'name'=>$request->get('name'),
            'head_key'=>$request->get('head_key'),
            'status'=>$request->get('status'),
        ]);
        return Response::json(['message' => 'Information Successfully Updated!'], 200);

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $feeHeadsDelete = $this->academicFeeHead->findOrFail($id);

        $feeHeadsDelete->delete();
        return ['message' => 'Successfully Deleted!'];
    }
}
