<?php
/**
 * Created by PhpStorm.
 * User: raja
 * Date: 3/19/16
 * Time: 11:35 AM
 */

namespace App\Forms;


use App\Models\Attendance\StudentAttendance;
use App\Models\Punch\Punch;
use App\Models\Setting\Setting;
class StudentAttendanceForm extends StudentAttendance implements FormInterface
{
    use FormControll,DataHelper;

    public function formInputFields($id = null, $mode = null)
    {

        $attForm= [

            [
                'type'=>'text',
                'name'=>self::ATTENDANCE_DATE,
                'label' => 'Date',
                'others'=>['class'=>'form-control',

                    'data-date-format'=>"yyyy-mm-dd",
                    'placeholder'=>'Select Date MAx Today'
                ],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'value'=>date("Y-m-d"),
                'validation'=>"required"
            ],
            [
                'type'=>'select',
                'name'=>self::STUDENT_CLASS,
                'label' => 'Class',
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 punch-user',
                'options'=>$this->classList(),
                'value'=>0,
                'validation'=>"required|in:".$this->classKeys()
            ],
            [
                'type'=>'select',
                'name'=>self::SECTION,
                'label' => 'Section',
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 punch-user',
                'options'=>['Select Class First'],//$this->sectionList(),
                'value'=>0,
                'validation'=>"required|in:".$this->sectionKeys()
            ],
            [
                'type'=>'select',
                'name'=>self::SUBJECT,
                'label' => 'Subject',
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 punch-user',
                'options'=>$this->subjectList(),
                'value'=>0,
                'isVisible'=>true,
                'validation'=>"in:".$this->subjectKeys()
            ],

        ];


        $theOption = (new  Setting())
        ->whereSettingName('Attendance')->first();

      //  $advanced=$theOption->setting_value;
       // if ($advanced =='0'){

          //  unset($attForm[3]);
       // }

       //unset($attForm[3]);

        return $attForm;




    }



}