<?php
/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 5/2/2016
 * Time: 12:47 PM
 */

namespace App\Forms;

use App\Http\Requests\Request;
use App\Http\Requests\Validator;
use Illuminate\Support\Facades\Input;
use App\Models\Building\Building;


class BuildingForm extends Building implements FormInterface
{
    use FormControll, DataHelper;

    protected $nonEditableFields = [];

    public function formInputFields($id = null, $mode = null)
    {
        return[
            [
                'type'=>'text',
                'name'=>self::BUILDING_NAME,
                'label' => 'Building Name',
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'trans'=>false,
                'others'=>[
                    'class'=>'form-control',
                ],
                'validation' => 'unique:site_buildings,building_name,'.$id.',id,building_name,'.Input::get(self::BUILDING_NAME).',site_id,'.session()->get(SITE_ID)

            ],
            [
                'type'=>'radio',
                'name'=>self::STATUS,
                'label' => 'Status',
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'radval'=> ['Active'=>'Active','Inactive'=>'Inactive'],
                'validation'=>"required",
                'checked'=>"Active"
            ],
            /*[
                'type'=>'submit',
                'label' => 'Submit',
                'others'=>[
                    'class'=>'btn btn-success',
                    'style'=>'background-color:#0073b7',
                    'readonly'=>'readonly'
                ],
            ]*/
            submitBtn($id),
        ];
    }
}