<?php

namespace App\Console\Commands;

use App\Models\Edu\Issue\IssueDetail;
use App\Models\Session\AdmissionPaymentSession;
use App\Models\Session\PaymentSession;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\StudentAdmission\GlobalSiteStudentAdmissionBoardApprove;
use App\Models\User\GlobalUser;
use App\Traits\Site\Fee\SonaliPayAdmissionFeeTrait;
use App\Traits\Site\Fee\SonaliPayStudentFeeTrait;
use Illuminate\Console\Command;
use Carbon\Carbon;

class PayFeeAutoUpdate extends Command
{

      use SonaliPayStudentFeeTrait, SonaliPayAdmissionFeeTrait;
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'fee:update';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'The bank that pays the fee but the fee is not updated on the site';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {

        $currentTime = Carbon::now('Asia/Dhaka');

        $this->checkStudentFeeSession($currentTime);
        $this->checkAdmissionFeeSession($currentTime);

       
        
    }

    protected function checkStudentFeeSession($currentTime){
        
        $studentFeeSessions=PaymentSession::where('end_date_time','<',$currentTime)
            ->where('status',1)
            ->orderBy('id','ASC')
            ->get();

          //   \Log::warning($studentFeeSessions);

        foreach($studentFeeSessions as $stdSession){

            $slip=GlobalSiteStudentFeeDemandSlipDetails::where('id',$stdSession->slip_id)->where('status',true)->first();
            $user=GlobalUser::where('id',$stdSession->user_id)->select('id','username')->first();

            if(!$slip || !$user){
                PaymentSession::where('id', $stdSession->id)->update(['status' => false]);
                continue;
            }

            $siteId=$stdSession->site_id;
            $academic_group_id=$slip->academic_group_id;
            $username=$user->username;

            $req_data=[
                'Token'=>$stdSession->token,
                'site_id'=>$siteId,
                'academic_group_id'=>$academic_group_id,
                'username'=>$username,
            ];
             

            $api_response=$this->verifyTransectionSonaliPayToken('site-student',$req_data);

            if($api_response['Status'] !== '200'){
                PaymentSession::where('id', $stdSession->id)->update(['status' => false]);
                continue;
            }

            if($api_response['Status']==='200'){
                $data=[
                    'Token'=>$stdSession->token,
                    'InvoiceNo'=>$slip->slip_no,
                    'InvoiceDate'=>$slip->created_date,
                    'TransactionId'=>$api_response['TransactionId'],
                ];

                $payment_update= $this->updateSoanliPayment($data);
            
                if($payment_update['status']=='200'){

                    $type='payment-auto-update-success:site-student'; 
                    $details='Student payment auto update success by sheadule, session_id:'.$stdSession->id;
                    $this->logIssue($type, $siteId, $username, $details);

                    PaymentSession::where('id', $stdSession->id)->update(['status' => false]);

                    continue;
                }else{

                    $type='payment-auto-update-failed:site-student'; 
                    $details='Student payment auto update failed by sheadule, session_id:'.$stdSession->id;

                    $this->logIssue($type, $siteId, $username, $details);

                    continue;
                }   
            
            }
        
        }
        
    }

    protected function checkAdmissionFeeSession($currentTime){

        $admissionFeeSessions=AdmissionPaymentSession::where('end_date_time','<',$currentTime)
            ->where('status',1)
            ->orderBy('id','ASC')
            ->get();

        foreach($admissionFeeSessions as $admiSession){

            $admissionSlip=GlobalSiteStudentAdmissionBoardApprove::where('id',$admiSession->site_student_admission_board_approve_id)
                ->where('payment_status',false)
                ->first();

            if(!$admissionSlip){
                AdmissionPaymentSession::where('id', $admiSession->id)->update(['status' => false]);
                continue;
            }

            $siteId=$admiSession->site_id;
            $academic_group_id=$admissionSlip->academic_group_id;
            $username=$admissionSlip->id;

            $req_data=[
                'Token'=>$admiSession->token,
                'site_id'=>$siteId,
                'academic_group_id'=>$academic_group_id,
                'username'=>$username,
            ];

            $api_response=$this->verifyTransectionSonaliPayToken('site-admission',$req_data);

            if($api_response['Status'] !== '200'){
                AdmissionPaymentSession::where('id', $admiSession->id)->update(['status' => false]);
                continue;
            }

            if($api_response['Status']==='200'){
                $data=[
                    'Token'=>$admiSession->token,
                    'InvoiceNo'=>$admissionSlip->invoice_no,
                    'InvoiceDate'=>$admissionSlip->created_date,
                    'TransactionId'=>$api_response['TransactionId'],
                ];

                $payment_update= $this->updateSoanliAdmissionPayment($data);
                
                if($payment_update['status']=='200'){

                    $type='payment-auto-update-success:site-admission';
                    $details='Admission payment auto update success by sheadule, session_id'.$admiSession->id;
                  
                    $this->logIssue($type, $siteId, $username, $details);

                    AdmissionPaymentSession::where('id', $admiSession->id)->update(['status' => false]);
                    continue;
                }else{

                    $type='payment-auto-update-failed:site-admission';
                    $details='Admission payment auto update failed by sheadule, session_id'.$admiSession->id;
                  
                    $this->logIssue($type, $siteId, $username, $details);
                     continue;
                }

                
            }
        }
    }

    protected function logIssue($type, $siteId, $username, $details)
    {
        IssueDetail::create([
            'issue_type' => $type,
            'issuer_type' => 'site',
            'issue_details' => $details,
            'site_id' => $siteId,
            'username' => $username,
            'ip_address' => request()->ip(),
        ]);
    }


}
