<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class DeployApp extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:deploy';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Deploy the application';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('Starting deployment...');

        $this->info('Putting the application into maintenance mode...');
        Artisan::call('down');
        
        $this->info('Clearing and caching configuration...');
        $this->info('Clearing and caching routes...');
        $this->info('Clearing and caching views...');
        Artisan::call('optimize');

        
        $this->info('Running migrations...');
        Artisan::call('migrate', ['--force' => true]);

       

        $this->info('Bringing the application back online...');
        Artisan::call('up');

        $this->info('Deployment completed successfully.');

      //  return Command::SUCCESS;
    }
}
