<?php

namespace App\Console\Commands;

use App\Models\Edu\Issue\IssueDetail;
use App\Models\Session\AdmissionPaymentSession;
use App\Models\Session\PaymentSession;
use App\Models\Site\Fee\Fine\GlobalSiteStudentFeeFine;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\StudentAdmission\GlobalSiteStudentAdmissionBoardApprove;
use App\Models\User\GlobalUser;
use App\Traits\Site\Fee\SonaliPayAdmissionFeeTrait;
use App\Traits\Site\Fee\SonaliPayStudentFeeTrait;
use Illuminate\Console\Command;
use Carbon\Carbon;

class CheckStudentFeeFine extends Command
{

     // use SonaliPayStudentFeeTrait, SonaliPayAdmissionFeeTrait;
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'add:fee-fine';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'The bank that pays the fee but the fee is not updated on the site';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $today_date = Carbon::now('Asia/Dhaka')->toDateString();

        $demand_slip_list = GlobalSiteStudentFeeDemandSlipDetails::where('payment_fine_status', true)
            ->where('status', true)
            ->where('payment_to_date', '<', $today_date)
            ->get(['id', 'delay_fine', 'student_history_id', 'site_id', 'academic_group_id']);

        $existing_fines = GlobalSiteStudentFeeFine::where('fee_type', 'delay_fine')
            ->whereIn('site_student_fee_demand_slip_details_id', $demand_slip_list->pluck('id'))
            ->pluck('site_student_fee_demand_slip_details_id')
            ->toArray();

        $new_fines = $demand_slip_list->filter(function ($slip) use ($existing_fines) {
            return !in_array($slip->id, $existing_fines);
        });


        $insert_data = $new_fines->map(function ($slip) {
            return [
                'site_student_fee_demand_slip_details_id' => $slip->id,
                'student_history_id' => $slip->student_history_id,
                'fine_amount' => $slip->delay_fine,
                'fee_type' => 'delay_fine',
                'status' => true,
                'site_id' => $slip->site_id,
                'academic_group_id' => $slip->academic_group_id,
                'created_at' => now(),
                'updated_at' => now(),
            ];
        })->toArray();

        if (!empty($insert_data)) {
            GlobalSiteStudentFeeFine::insert($insert_data);
        }
        
    }

   

}
